/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.SessionClient;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.util.RunnableExceptionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClientSessionManager {
    private static final Logger log = LoggerFactory.getLogger(ClientSessionManager.class);
    private final ScheduledExecutorService executorService;
    private final Client client;
    private final SessionClient sessionClient;
    private ScheduledFuture<?> scheduledFuture;
    private UUID sessionId;

    @Inject
    ClientSessionManager(ScheduledExecutorService executorService, @Nullable Client client2, SessionClient sessionClient) {
        this.executorService = executorService;
        this.client = client2;
        this.sessionClient = sessionClient;
    }

    public void start() {
        this.executorService.execute(() -> {
            try {
                this.sessionId = this.sessionClient.open();
                log.debug("Opened session {}", (Object)this.sessionId);
            }
            catch (IOException ex2) {
                log.warn("error opening session", ex2);
            }
        });
        this.scheduledFuture = this.executorService.scheduleWithFixedDelay(RunnableExceptionLogger.wrap(this::ping), 1L, 10L, TimeUnit.MINUTES);
    }

    @Subscribe
    private void onClientShutdown(ClientShutdown e2) {
        this.scheduledFuture.cancel(true);
        e2.waitFor(this.executorService.submit(() -> {
            try {
                UUID localUuid = this.sessionId;
                if (localUuid != null) {
                    this.sessionClient.delete(localUuid);
                }
            }
            catch (IOException ex2) {
                log.warn(null, ex2);
            }
            this.sessionId = null;
        }));
    }

    private void ping() {
        try {
            if (this.sessionId == null) {
                this.sessionId = this.sessionClient.open();
                log.debug("Opened session {}", (Object)this.sessionId);
                return;
            }
        }
        catch (IOException ex2) {
            log.warn("unable to open session", ex2);
            return;
        }
        boolean loggedIn = false;
        if (this.client != null) {
            GameState gameState = this.client.getGameState();
            loggedIn = gameState.getState() >= GameState.LOADING.getState();
        }
        try {
            this.sessionClient.ping(this.sessionId, loggedIn);
        }
        catch (IOException ex3) {
            log.warn("Resetting session", ex3);
            this.sessionId = null;
        }
    }
}

